<?php

/**
 * This is the model class for table "claim".
 *
 * The followings are the available columns in table 'claim':
 * @property integer $id
 * @property string $file_no
 * @property string $claim_no
 * @property integer $suppliment_exist
 * @property integer $created_by
 * @property string $close_date
 * @property integer $status
 * @property integer $reopened
 * @property string $policy_no
 * @property double $policy_limit
 * @property integer $deducitible_waived
 * @property double $deducitible
 * @property string $date_of_loss
 * @property string $assignment_type
 * @property string $loss_type
 * @property string $claim_report_date
 * @property string $whoose_claim
 * @property integer $coverage_verified
 * @property string $type_of_coverage
 * @property integer $branch_id
 * @property string $ob_address1
 * @property string $ob_address2
 * @property string $ob_city
 * @property integer $ob_state_id
 * @property string $ob_zip
 * @property integer $adjustor_id
 * @property string $ob_phone
 * @property string $ob_fax
 * @property string $ob_email
 * @property string $c_first_name
 * @property string $c_last_name
 * @property string $c_address1
 * @property string $c_addres2
 * @property string $c_city
 * @property integer $c_state_id
 * @property string $c_zip
 * @property string $c_cell
 * @property string $c_home
 * @property string $c_work
 * @property string $c_fax
 * @property string $c_email
 * @property string $i_first_name
 * @property string $i_last_name
 * @property string $i_address1
 * @property string $i_address2
 * @property string $i_city
 * @property integer $i_state_id
 * @property string $i_zip
 * @property string $i_home
 * @property string $i_work
 * @property string $i_cell
 * @property string $i_fax
 * @property string $i_email
 * @property string $o_first_name
 * @property string $o_last_name
 * @property string $o_address1
 * @property string $o_address2
 * @property string $o_city
 * @property integer $o_state_id
 * @property string $o_zip
 * @property string $o_home
 * @property string $o_work
 * @property string $o_cell
 * @property string $o_fax
 * @property string $o_email
 * @property string $v_location_name
 * @property string $v_address1
 * @property string $v_address2
 * @property string $v_city
 * @property integer $v_state_id
 * @property string $v_zip
 * @property string $v_phone
 * @property string $v_email
 * @property string $v_year
 * @property integer $v_make_id
 * @property integer $v_model_id
 * @property string $v_submodel
 * @property string $v_lien_holder
 * @property string $v_color
 * @property string $v_plate_no
 * @property integer $v_plate_country
 * @property integer $v_plate_state_id
 * @property string $v_milege
 * @property string $v_style
 * @property string $v_drivable
 * @property string $ty_make
 * @property string $ty_size
 * @property string $ty_lf
 * @property string $ty_lr
 * @property string $ty_rf
 * @property string $ty_rr
 * @property string $ty_spare
 * @property string $ad_primary_poi
 * @property string $ad_secondary_poi
 * @property string $ad_vehicle_condition
 * @property string $ad_interior_condition
 * @property string $ad_paint_condition
 * @property string $ad_engine_condition
 * @property string $ad_pay_code
 * @property string $ad_rental_vehicle
 * @property string $ad_storage
 * @property string $ad_permission_to_move
 * @property string $rp_shop_name
 * @property string $rp_address1
 * @property string $rpo_address2
 * @property string $rp_city
 * @property integer $rp_state_id
 * @property string $rp_zip
 * @property string $rp_phone
 * @property string $rp_fax
 * @property integer $rp_aggreed_price
 * @property string $rp_federal_tax_id
 * @property string $rp_ert_days
 * @property string $rp_posiible_supplement
 * @property string $rp_originalnet_loss
 * @property string $rp_supplement_net_loss
 * @property string $adi_special_instruction
 * @property string $adi_damage_description
 * @property string $adi_prior_damage
 * @property string $adi_accident_description
 * @property integer $ali_vehicel_appointment_setup
 * @property string $ali_recommendation
 * @property string $ali_total_loss
 * @property string $gui_company_guidelines
 * @property string $gui_branch_guidelines
 * @property string $created
 * @property string $modified
 *
 * The followings are the available model relations:
 * @property Branch $branch
 * @property User $createdBy
 * @property State $cState
 * @property State $iState
 * @property State $obState
 * @property State $oState
 * @property State $rpState
 * @property State $vPlateState
 * @property State $vState
 * @property Reopenclaim[] $reopenclaims
 * @property Supplement[] $supplements
 */
class Claim extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Claim the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'claim';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('file_no, claim_no, created_by, assignment_type, loss_type, whoose_claim, branch_id, adjustor_id, i_first_name, i_last_name, i_address1, i_city, v_state_id, v_zip, v_phone, v_make_id, v_model_id,tpa_branch,delivery_method', 'required'),
			array('suppliment_exist, created_by, status, reopened, deducitible_waived, coverage_verified, branch_id, ob_state_id, adjustor_id, c_state_id, i_state_id, o_state_id, v_state_id, v_make_id, v_model_id, v_plate_country, v_plate_state_id, rp_state_id, rp_aggreed_price, ali_vehicel_appointment_setup,tpa_branch', 'numerical', 'integerOnly'=>true),
			array('policy_limit, deducitible', 'numerical'),
			array('file_no, claim_no, policy_no', 'length', 'max'=>455),
			array('assignment_type', 'length', 'max'=>19),
			array('loss_type', 'length', 'max'=>13),
			array('whoose_claim', 'length', 'max'=>8),
			array('type_of_coverage, ob_city, ob_zip, ob_phone, ob_fax, c_first_name, c_last_name, c_city, c_zip, c_cell, c_home, c_work, c_fax, c_email, i_first_name, i_last_name, i_city, i_zip, i_home, i_work, i_cell, i_fax, i_email, o_first_name, o_last_name, o_city, o_zip, o_home, o_work, o_cell, o_fax, o_email, v_location_name, v_city, v_zip, v_phone, v_email, v_year, v_submodel, v_lien_holder, v_color, v_plate_no, v_milege, v_style, ty_make, ty_size, ty_lf, ty_lr, ty_rf, ty_rr, ty_spare, ad_primary_poi, ad_secondary_poi, ad_interior_condition, ad_paint_condition, ad_engine_condition, ad_pay_code, rp_shop_name, rp_city, rp_zip, rp_phone, rp_fax, rp_federal_tax_id, rp_ert_days, rp_posiible_supplement, rp_originalnet_loss, rp_supplement_net_loss', 'length', 'max'=>45),
			array('ob_email', 'length', 'max'=>445),
			array('v_drivable, ad_vehicle_condition, ad_rental_vehicle, ad_storage, ad_permission_to_move, adi_prior_damage, ali_total_loss', 'length', 'max'=>7),
			array('ali_recommendation', 'length', 'max'=>21),
			array('close_date, date_of_loss, claim_report_date, ob_address1, ob_address2, c_address1, c_addres2, i_address2, o_address1, o_address2, v_address1, v_address2, rp_address1, rpo_address2, adi_special_instruction, adi_damage_description, adi_accident_description, gui_company_guidelines, gui_branch_guidelines, created, modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, other_assignment_type,tpa_branch,tpa_city,tpa_state,tpa_address1,tpa_address2,tpa_zip,tpa_adjuster,tpa_email,tpa_phone,tpa_fax,file_no, claim_no, suppliment_exist, created_by, close_date, status, reopened, policy_no, policy_limit, deducitible_waived, deducitible, date_of_loss, assignment_type, loss_type, claim_report_date, whoose_claim, coverage_verified, type_of_coverage, branch_id, ob_address1, ob_address2, ob_city, ob_state_id, ob_zip, adjustor_id, ob_phone, ob_fax, ob_email, c_first_name, c_last_name, c_address1, c_addres2, c_city, c_state_id, c_zip, c_cell, c_home, c_work, c_fax, c_email, i_first_name, i_last_name, i_address1, i_address2, i_city, i_state_id, i_zip, i_home, i_work, i_cell, i_fax, i_email, o_first_name, o_last_name, o_address1, o_address2, o_city, o_state_id, o_zip, o_home, o_work, o_cell, o_fax, o_email, v_location_name, v_address1, v_address2, v_city, v_state_id, v_zip, v_phone, v_email, v_year, v_make_id, v_model_id, v_submodel, v_lien_holder, v_color, v_plate_no, v_plate_country, v_plate_state_id, v_milege, v_style, v_drivable, ty_make, ty_size, ty_lf, ty_lr, ty_rf, ty_rr, ty_spare, ad_primary_poi, ad_secondary_poi, ad_vehicle_condition, ad_interior_condition, ad_paint_condition, ad_engine_condition, ad_pay_code, ad_rental_vehicle, ad_storage, ad_permission_to_move, rp_shop_name, rp_address1, rpo_address2, rp_city, rp_state_id, rp_zip, rp_phone, rp_fax, rp_aggreed_price, rp_federal_tax_id, rp_ert_days, rp_posiible_supplement, rp_originalnet_loss, rp_supplement_net_loss, adi_special_instruction, adi_damage_description, adi_prior_damage, adi_accident_description, ali_vehicel_appointment_setup, ali_recommendation, ali_total_loss, gui_company_guidelines, gui_branch_guidelines, created, modified', 'safe', 'on'=>'search'),
			 array(
                                        'modified','default',
                                        'value'=>new CDbExpression('NOW()'),
                                        'setOnEmpty'=>false,'on'=>'update'
                        ),
                        array(
                                'created,modified','default',
                                'value'=>new CDbExpression('NOW()'),
                                'setOnEmpty'=>false,'on'=>'insert'
                        ),
		);
	}

	public static function getNewFileNumber()
	{
		$uid=Yii::app()->user->id;
		 $today_date = date("Y-m-d", time());

			 //,year(alert_date) as y,month(alert_date) as m, day(alert_date) as d
			  $sql= "SELECT  count(id) as cnt from claim where DATE_FORMAT(created, '%Y-%m-%d') = '".$today_date."'";
			  $sql="select file_no from claim order by `created` desc limit 1";
        //$name = $uid;
        return Yii::app()->db->createCommand($sql)->queryAll();
 	
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'branch' => array(self::BELONGS_TO, 'Branch', 'branch_id'),
			'createdBy' => array(self::BELONGS_TO, 'User', 'created_by'),
                    'adjuster' => array(self::BELONGS_TO, 'User', 'adjustor_id'),
			'cState' => array(self::BELONGS_TO, 'State', 'c_state_id'),
			'iState' => array(self::BELONGS_TO, 'State', 'i_state_id'),
			'obState' => array(self::BELONGS_TO, 'State', 'ob_state_id'),
			'oState' => array(self::BELONGS_TO, 'State', 'o_state_id'),
			'rpState' => array(self::BELONGS_TO, 'State', 'rp_state_id'),
			'vPlateState' => array(self::BELONGS_TO, 'State', 'v_plate_state_id'),
			'vState' => array(self::BELONGS_TO, 'State', 'v_state_id'),
			'reopenclaims' => array(self::HAS_MANY, 'Reopenclaim', 'claim_id'),
			'supplements' => array(self::HAS_MANY, 'Supplement', 'claim_id'),
                        'appraisalcompanyinvoice' => array(self::HAS_MANY, 'Appraisalcompanyinvoice', 'claim_id'),
                    'appraisalinvoice' => array(self::HAS_MANY, 'Appraisalinvoice', 'claim_id'),
                    'bodyshopinvoice' => array(self::HAS_MANY, 'Bodyshopinvoice', 'claim_id'),
                    'callcenterinvoice' => array(self::HAS_MANY, 'Callcenterinvoice', 'claim_id'),
                    'cfsinvoice' => array(self::HAS_MANY, 'Cfsinvoice', 'claim_id'),
                    'deskreviewerinvoice' => array(self::HAS_MANY, 'Deskreviewerinvoice', 'claim_id'),
                    'payout' => array(self::HAS_MANY, 'Payout', 'claim_id'),
                    'country' => array(self::BELONGS_TO, 'Country', 'v_plate_country'),
                    'tpabranch' => array(self::BELONGS_TO, 'Branch', 'tpa_branch'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_no' => 'File Number',
			'claim_no' => 'Claim Number',
			'suppliment_exist' => 'Suppliment Exist',
			'created_by' => 'Created By',
			'close_date' => 'Close Date',
			'status' => 'Status',
			'reopened' => 'Reopened',
			'policy_no' => 'Policy Number',
			'policy_limit' => 'Policy Limit',
			'deducitible_waived' => 'Deductible Waived?',
			'deducitible' => 'Deducitible',
			'date_of_loss' => 'Date Of Loss',
			'assignment_type' => 'Assignment Type',
			'loss_type' => 'Loss Type',
			'claim_report_date' => 'Claim Report Date',
			'whoose_claim' => 'Whoose Claim',
			'coverage_verified' => 'Coverage Verified',
			'type_of_coverage' => 'Type Of Coverage',
			'branch_id' => 'Branch',
			'ob_address1' => 'Address 1',
			'ob_address2' => 'Address 2',
			'ob_city' => 'City',
			'ob_state_id' => 'State',
			'ob_zip' => 'Zip',
			'adjustor_id' => 'Adjustor',
			'ob_phone' => 'Phone',
			'ob_fax' => 'Fax',
			'ob_email' => 'Email',
			'c_first_name' => 'Claimant First Name',
			'c_last_name' => 'Claimant Last Name',
			'c_address1' => 'Address Line 1',
			'c_addres2' => 'Addres Line 2',
			'c_city' => 'City',
			'c_state_id' => 'State',
			'c_zip' => 'Zip',
			'c_cell' => 'Cell Number',
			'c_home' => 'Home Number',
			'c_work' => 'Work Number',
			'c_fax' => 'Fax',
			'c_email' => 'Email',
			'i_first_name' => 'Insured First Name',
			'i_last_name' => 'Insured Last Name',
			'i_address1' => 'Address Line 1',
			'i_address2' => 'Address Line 2',
			'i_city' => 'City',
			'i_state_id' => 'State',
			'i_zip' => 'Zip',
			'i_home' => 'Home Number',
			'i_work' => 'Work Number',
			'i_cell' => 'Cell Number',
			'i_fax' => 'Fax',
			'i_email' => 'Email',
			'o_first_name' => 'Owner First Name',
			'o_last_name' => 'Owner Last Name',
			'o_address1' => 'Address Line 1',
			'o_address2' => 'Address Line 2',
			'o_city' => 'City',
			'o_state_id' => 'State',
			'o_zip' => 'Zip',
			'o_home' => 'Home Number',
			'o_work' => 'Work Number',
			'o_cell' => 'Cell Number',
			'o_fax' => 'Fax',
			'o_email' => 'Email',
			'v_location_name' => 'Location Name',
			'v_address1' => 'Address Line 1',
			'v_address2' => 'Address Line 2',
			'v_city' => 'City',
			'v_state_id' => 'State',
			'v_zip' => 'Zip',
			'v_phone' => 'Phone',
			'v_email' => 'Email',
			'v_year' => 'Year',
			'v_make_id' => 'Make',
			'v_model_id' => 'Model',
			'v_submodel' => 'Sub-Model',
			'v_lien_holder' => 'Lien Holder',
			'v_color' => 'Color',
			'v_plate_no' => 'Plate No',
			'v_plate_country' => 'Plate Country',
			'v_plate_state_id' => 'Plate State',
			'v_milege' => 'Milege',
			'v_style' => 'Style',
			'v_drivable' => 'Drivable',
			'ty_make' => 'Make',
			'ty_size' => 'Size',
			'ty_lf' => 'L/F',
			'ty_lr' => 'L/R',
			'ty_rf' => 'R/F',
			'ty_rr' => 'R/R',
			'ty_spare' => 'Spare',
			'ad_primary_poi' => 'Primary Poi',
			'ad_secondary_poi' => 'Secondary Poi',
			'ad_vehicle_condition' => 'Vehicle Condition',
			'ad_interior_condition' => 'Interior Condition',
			'ad_paint_condition' => 'Paint Condition',
			'ad_engine_condition' => 'Engine',
			'ad_pay_code' => 'Pay Code',
			'ad_rental_vehicle' => 'Rental Vehicle',
                        'ad_rental_max_days'=>'Rental Max Days',
                        'ad_rental_max_aount'=>'Rental Max Amount',
			'ad_storage' => 'Storage',
			'ad_permission_to_move' => 'Permission To Move',
			'rp_shop_name' => 'Shop Name',
			'rp_address1' => 'Address 1',
			'rpo_address2' => 'Address 2',
			'rp_city' => 'City',
			'rp_state_id' => 'State',
			'rp_zip' => 'Zip',
			'rp_phone' => 'Phone',
			'rp_fax' => 'Fax',
			'rp_aggreed_price' => 'Aggreed Price',
			'rp_federal_tax_id' => 'Federal Tax ID#',
			'rp_ert_days' => 'ERT(Days)',
			'rp_posiible_supplement' => 'Posiible Supplement',
			'rp_originalnet_loss' => 'Originalnet Loss',
			'rp_supplement_net_loss' => 'Supplement Net Loss',
			'adi_special_instruction' => 'Special Instruction',
			'adi_damage_description' => 'Damage Description',
			'adi_prior_damage' => 'Prior Damage',
			'adi_accident_description' => 'Accident Description',
			'ali_vehicel_appointment_setup' => 'Appointment ⁄ Loss Vehicel Appointment Setup',
			'ali_recommendation' => 'Appointment ⁄ Loss Recommendation',
			'ali_total_loss' => 'Appointment ⁄ Loss Total Loss',
			'gui_company_guidelines' => 'Guidelines Company Guidelines',
			'gui_branch_guidelines' => 'Guidelines Branch Guidelines',
			'created' => 'Created',
			'modified' => 'Modified',
                        'tpa_branch'=>'Company Branches',
                        'tpa_address1'=>'Address 1',
                        'tpa_address2'=>'Address 2',
                        'tpa_city'=>'City',
                        'tpa_state'=>'State',
                        'tpa_zip'=>'Zip',
                        'tpa_adjuster'=>'Adjuster',
                        'tpa_fax'=>'Fax',
                        'tpa_email'=>'Email',
                        'other_assignment_type'=>'Other Assignment Type',
                        'other_loss_type'=>'Other Loss Type',
                        'delivery_method'=>'Delivery Method',
                        'status_interval'=>'Status Interval',
                        'v_different_location'=>'Different Location',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('file_no',$this->file_no,true);
		$criteria->compare('claim_no',$this->claim_no,true);
		$criteria->compare('suppliment_exist',$this->suppliment_exist);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('close_date',$this->close_date,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('reopened',$this->reopened);
		$criteria->compare('policy_no',$this->policy_no,true);
		$criteria->compare('policy_limit',$this->policy_limit);
		$criteria->compare('deducitible_waived',$this->deducitible_waived);
		$criteria->compare('deducitible',$this->deducitible);
		$criteria->compare('date_of_loss',$this->date_of_loss,true);
		$criteria->compare('assignment_type',$this->assignment_type,true);
		$criteria->compare('loss_type',$this->loss_type,true);
		$criteria->compare('claim_report_date',$this->claim_report_date,true);
		$criteria->compare('whoose_claim',$this->whoose_claim,true);
		$criteria->compare('coverage_verified',$this->coverage_verified);
		$criteria->compare('type_of_coverage',$this->type_of_coverage,true);
		$criteria->compare('branch_id',$this->branch_id);
		$criteria->compare('ob_address1',$this->ob_address1,true);
		$criteria->compare('ob_address2',$this->ob_address2,true);
		$criteria->compare('ob_city',$this->ob_city,true);
		$criteria->compare('ob_state_id',$this->ob_state_id);
		$criteria->compare('ob_zip',$this->ob_zip,true);
		$criteria->compare('adjustor_id',$this->adjustor_id);
		$criteria->compare('ob_phone',$this->ob_phone,true);
		$criteria->compare('ob_fax',$this->ob_fax,true);
		$criteria->compare('ob_email',$this->ob_email,true);
		$criteria->compare('c_first_name',$this->c_first_name,true);
		$criteria->compare('c_last_name',$this->c_last_name,true);
		$criteria->compare('c_address1',$this->c_address1,true);
		$criteria->compare('c_addres2',$this->c_addres2,true);
		$criteria->compare('c_city',$this->c_city,true);
		$criteria->compare('c_state_id',$this->c_state_id);
		$criteria->compare('c_zip',$this->c_zip,true);
		$criteria->compare('c_cell',$this->c_cell,true);
		$criteria->compare('c_home',$this->c_home,true);
		$criteria->compare('c_work',$this->c_work,true);
		$criteria->compare('c_fax',$this->c_fax,true);
		$criteria->compare('c_email',$this->c_email,true);
		$criteria->compare('i_first_name',$this->i_first_name,true);
		$criteria->compare('i_last_name',$this->i_last_name,true);
		$criteria->compare('i_address1',$this->i_address1,true);
		$criteria->compare('i_address2',$this->i_address2,true);
		$criteria->compare('i_city',$this->i_city,true);
		$criteria->compare('i_state_id',$this->i_state_id);
		$criteria->compare('i_zip',$this->i_zip,true);
		$criteria->compare('i_home',$this->i_home,true);
		$criteria->compare('i_work',$this->i_work,true);
		$criteria->compare('i_cell',$this->i_cell,true);
		$criteria->compare('i_fax',$this->i_fax,true);
		$criteria->compare('i_email',$this->i_email,true);
		$criteria->compare('o_first_name',$this->o_first_name,true);
		$criteria->compare('o_last_name',$this->o_last_name,true);
		$criteria->compare('o_address1',$this->o_address1,true);
		$criteria->compare('o_address2',$this->o_address2,true);
		$criteria->compare('o_city',$this->o_city,true);
		$criteria->compare('o_state_id',$this->o_state_id);
		$criteria->compare('o_zip',$this->o_zip,true);
		$criteria->compare('o_home',$this->o_home,true);
		$criteria->compare('o_work',$this->o_work,true);
		$criteria->compare('o_cell',$this->o_cell,true);
		$criteria->compare('o_fax',$this->o_fax,true);
		$criteria->compare('o_email',$this->o_email,true);
		$criteria->compare('v_location_name',$this->v_location_name,true);
		$criteria->compare('v_address1',$this->v_address1,true);
		$criteria->compare('v_address2',$this->v_address2,true);
		$criteria->compare('v_city',$this->v_city,true);
		$criteria->compare('v_state_id',$this->v_state_id);
		$criteria->compare('v_zip',$this->v_zip,true);
		$criteria->compare('v_phone',$this->v_phone,true);
		$criteria->compare('v_email',$this->v_email,true);
		$criteria->compare('v_year',$this->v_year,true);
		$criteria->compare('v_make_id',$this->v_make_id);
		$criteria->compare('v_model_id',$this->v_model_id);
		$criteria->compare('v_submodel',$this->v_submodel,true);
		$criteria->compare('v_lien_holder',$this->v_lien_holder,true);
		$criteria->compare('v_color',$this->v_color,true);
		$criteria->compare('v_plate_no',$this->v_plate_no,true);
		$criteria->compare('v_plate_country',$this->v_plate_country);
		$criteria->compare('v_plate_state_id',$this->v_plate_state_id);
		$criteria->compare('v_milege',$this->v_milege,true);
		$criteria->compare('v_style',$this->v_style,true);
		$criteria->compare('v_drivable',$this->v_drivable,true);
		$criteria->compare('ty_make',$this->ty_make,true);
		$criteria->compare('ty_size',$this->ty_size,true);
		$criteria->compare('ty_lf',$this->ty_lf,true);
		$criteria->compare('ty_lr',$this->ty_lr,true);
		$criteria->compare('ty_rf',$this->ty_rf,true);
		$criteria->compare('ty_rr',$this->ty_rr,true);
		$criteria->compare('ty_spare',$this->ty_spare,true);
		$criteria->compare('ad_primary_poi',$this->ad_primary_poi,true);
		$criteria->compare('ad_secondary_poi',$this->ad_secondary_poi,true);
		$criteria->compare('ad_vehicle_condition',$this->ad_vehicle_condition,true);
		$criteria->compare('ad_interior_condition',$this->ad_interior_condition,true);
		$criteria->compare('ad_paint_condition',$this->ad_paint_condition,true);
		$criteria->compare('ad_engine_condition',$this->ad_engine_condition,true);
		$criteria->compare('ad_pay_code',$this->ad_pay_code,true);
		$criteria->compare('ad_rental_vehicle',$this->ad_rental_vehicle,true);
		$criteria->compare('ad_storage',$this->ad_storage,true);
		$criteria->compare('ad_permission_to_move',$this->ad_permission_to_move,true);
		$criteria->compare('rp_shop_name',$this->rp_shop_name,true);
		$criteria->compare('rp_address1',$this->rp_address1,true);
		$criteria->compare('rpo_address2',$this->rpo_address2,true);
		$criteria->compare('rp_city',$this->rp_city,true);
		$criteria->compare('rp_state_id',$this->rp_state_id);
		$criteria->compare('rp_zip',$this->rp_zip,true);
		$criteria->compare('rp_phone',$this->rp_phone,true);
		$criteria->compare('rp_fax',$this->rp_fax,true);
		$criteria->compare('rp_aggreed_price',$this->rp_aggreed_price);
		$criteria->compare('rp_federal_tax_id',$this->rp_federal_tax_id,true);
		$criteria->compare('rp_ert_days',$this->rp_ert_days,true);
		$criteria->compare('rp_posiible_supplement',$this->rp_posiible_supplement,true);
		$criteria->compare('rp_originalnet_loss',$this->rp_originalnet_loss,true);
		$criteria->compare('rp_supplement_net_loss',$this->rp_supplement_net_loss,true);
		$criteria->compare('adi_special_instruction',$this->adi_special_instruction,true);
		$criteria->compare('adi_damage_description',$this->adi_damage_description,true);
		$criteria->compare('adi_prior_damage',$this->adi_prior_damage,true);
		$criteria->compare('adi_accident_description',$this->adi_accident_description,true);
		$criteria->compare('ali_vehicel_appointment_setup',$this->ali_vehicel_appointment_setup);
		$criteria->compare('ali_recommendation',$this->ali_recommendation,true);
		$criteria->compare('ali_total_loss',$this->ali_total_loss,true);
		$criteria->compare('gui_company_guidelines',$this->gui_company_guidelines,true);
		$criteria->compare('gui_branch_guidelines',$this->gui_branch_guidelines,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}